/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.fsp.FSPCMRespHdlr;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspIoConCmds {
    public static final int CM_TIMEOUT = 300000;
    private static FspIoConCmds mInst;
    private static final String GET_POWER_DOMAIN = "GET_POWER_DOMAIN";
    private static final String GET_POWER_DOMAIN_POWER_STATE = "GET_POWER_DOMAIN_POWER_STATE";
    private static final String ACQUIRE_POWER_DOMAIN_SERVICE_LOCK = "ACQUIRE_POWER_DOMAIN_SERVICE_LOCK";
    private static final String RELEASE_POWER_DOMAIN_SERVICE_LOCK = "RELEASE_POWER_DOMAIN_SERVICE_LOCK";
    private static final String POWER_ON_POWER_DOMAIN = "POWER_ON_POWER_DOMAIN";
    private static final String POWER_OFF_POWER_DOMAIN = "POWER_OFF_POWER_DOMAIN";
    private static final String CAN_VARY_OFF_POWER_DOMAIN = "CAN_VARY_OFF_POWER_DOMAIN";
    private static final String VARY_OFF_POWER_DOMAIN = "VARY_OFF_POWER_DOMAIN";
    private static final String VARY_ON_POWER_DOMAIN = "VARY_ON_POWER_DOMAIN";
    private static final String HYP_PIPE_CANCEL_REQUEST = "HYP_PIPE_CANCEL_REQUEST";
    private static final String GET_REMAINING_RESP_DATA = "GET_REMAINING_RESP_DATA";
    private static final String GET_CEC_CONFIG_ID = "GET_CEC_CONFIG_ID";
    private static final String CONFIG_ID = "CONFIG_ID";
    private static final String SET_CEC_CONFIG_ID = "SET_CEC_CONFIG_ID";
    private static final String SET_IO_DRAWER_MTMS = "SET_IO_DRAWER_MTMS";
    private static final String SET_IO_DRAWER_CONFIG_ID = "SET_IO_DRAWER_CONFIG_ID";
    private static final String ANN_ADD_REMOVE_CMD = "ANN_ADD_REMOVE_CMD";
    private static long ANN_TIMEOUT;
    private static int RACK_ADD;
    private static int UNIT_ADD;
    private static short REMOVE_CAGE;
    private static short SPCN_CMD;
    private static short ADD_CAGE;
    private static final String CLEAR_INACTIVE = "CLEAR_INACTIVE";
    private static final String CLEAR_IO_TABLE = "CLEAR_IO_TABLE";
    private static short CLEAR_TABLE;

    static FspIoConCmds getInstance() {
        if (mInst == null) {
            mInst = new FspIoConCmds();
        }
        return mInst;
    }

    private FspIoConCmds() {
    }

    Hashtable getPowerDomainCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        hashtable = fSPCmdMgr.doPhypCommand(GET_POWER_DOMAIN, new String[]{unsignedInt16.toString(), string});
        return hashtable;
    }

    Hashtable getPowerDomainPowerStateCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        hashtable = fSPCmdMgr.doPhypCommand(GET_POWER_DOMAIN_POWER_STATE, new String[]{unsignedInt16.toString(), string});
        return hashtable;
    }

    Hashtable acquirePowerDomainServiceLockCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        hashtable = fSPCmdMgr.doPhypCommand(ACQUIRE_POWER_DOMAIN_SERVICE_LOCK, new String[]{unsignedInt16.toString(), string});
        return hashtable;
    }

    Hashtable releasePowerDomainServiceLockCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        hashtable = fSPCmdMgr.doPhypCommand(RELEASE_POWER_DOMAIN_SERVICE_LOCK, new String[]{unsignedInt16.toString(), string});
        return hashtable;
    }

    Hashtable powerOnPowerDomainCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        hashtable = fSPCmdMgr.doPhypCommand(POWER_ON_POWER_DOMAIN, new String[]{unsignedInt16.toString(), string}, 300000, null, null, null, null, null);
        return hashtable;
    }

    Hashtable powerOffPowerDomainCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        hashtable = fSPCmdMgr.doPhypCommand(POWER_OFF_POWER_DOMAIN, new String[]{unsignedInt16.toString(), string}, 300000, null, null, null, null, null);
        return hashtable;
    }

    Hashtable canVaryOffPowerDomainCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(0);
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        hashtable = fSPCmdMgr.doPhypCommand(CAN_VARY_OFF_POWER_DOMAIN, new String[]{unsignedInt8.toString(), unsignedInt16.toString(), string});
        return hashtable;
    }

    Hashtable varyOffPowerDomainCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        hashtable = fSPCmdMgr.doPhypCommand(VARY_OFF_POWER_DOMAIN, new String[]{unsignedInt16.toString(), string});
        return hashtable;
    }

    Hashtable varyOnPowerDomainCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        hashtable = fSPCmdMgr.doPhypCommand(VARY_ON_POWER_DOMAIN, new String[]{unsignedInt16.toString(), string});
        return hashtable;
    }

    Hashtable cancelHypPipeRequestCmd(FSPCmdMgr fSPCmdMgr, int n) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doPhypCommand(HYP_PIPE_CANCEL_REQUEST, new String[]{new Integer(n).toString()});
        return hashtable;
    }

    Hashtable getRemainingRespDataCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt32 unsignedInt32) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doPhypCommand(GET_REMAINING_RESP_DATA, new String[]{unsignedInt32.toString()});
        return hashtable;
    }

    public int generateCommandId(FSPCmdMgr fSPCmdMgr) {
        return fSPCmdMgr.genCmdId();
    }

    public int[] doGroupCommand(FSPCmdMgr fSPCmdMgr, Vector vector, String string, String string2, int[] nArray, FSPCMRespHdlr fSPCMRespHdlr, int n) throws PIHscCmdMgrException {
        return fSPCmdMgr.doGroupCmd(vector, string, string2, nArray, fSPCMRespHdlr, n);
    }

    public UnsignedInt32 getConfigId(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doPhypCommand(GET_CEC_CONFIG_ID, null);
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)hashtable.get(CONFIG_ID);
        return unsignedInt32;
    }

    public void setConfigId(FSPCmdMgr fSPCmdMgr, UnsignedInt32 unsignedInt32) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doPhypCommand(SET_CEC_CONFIG_ID, new String[]{unsignedInt32.toString()});
    }

    /*
     * WARNING - void declaration
     */
    public void setIoDrawerMtmsCmd(FSPCmdMgr fSPCmdMgr, String string, String string2, String string3, String string4) throws PIHscServerException, PIHscCmdMgrException {
        short s;
        void var8_11;
        int n = 0;
        int n2 = 4;
        n2 += string.length();
        n2 += string2.length();
        int s2 = string3.length();
        System.out.println("The io serial length is " + s2);
        if (s2 < 12) {
            int n3 = 12 - s2;
        } else {
            boolean bl = false;
        }
        System.out.println("The len2 to add for io serial is :" + (int)var8_11);
        for (s = 0; s < var8_11; ++s) {
            string3 = string3 + "\u0000";
        }
        System.out.println("The io serial length after manpulation is:" + string3.length());
        n2 += string3.length();
        System.out.println("The Location code length is :" + string4.length());
        s = (short)string4.length();
        int n4 = 4 - string4.length() % 4;
        System.out.println("The len3 to add for loc code is :" + n4);
        for (int i = 0; i < n4; ++i) {
            string4 = string4 + "\u0000";
        }
        System.out.println("The location code length afte the manipulation is :" + string4.length());
        System.out.println("The length is " + (n2 += string4.length()));
        try {
            Hashtable hashtable = fSPCmdMgr.doPhypCommand(SET_IO_DRAWER_MTMS, new String[]{new UnsignedInt16(n2).toString(), ByteUtilities.toHexString(string.getBytes()), ByteUtilities.toHexString(string2.getBytes()), ByteUtilities.toHexString(string3.getBytes()), new UnsignedInt8(s).toString(), new UnsignedInt8((short)string4.length()).toString(), ByteUtilities.toHexString(string4.getBytes())});
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            n = pIHscCmdMgrException.getStatus();
            HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
            if (n == 25) {
                throw new PIHscServerException("3421", pIHscCmdMgrException);
            }
            if (n == 28) {
                throw new PIHscServerException("3422", pIHscCmdMgrException);
            }
            if (n == 3) {
                throw new PIHscServerException("3423", pIHscCmdMgrException);
            }
            throw new PIHscServerException("3424", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
        }
    }

    public void setIoDrawerConfigIdCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, String string) throws PIHscServerException, PIHscCmdMgrException {
        int n = 0;
        int n2 = 6;
        int n3 = string.length();
        short s = (short)n3;
        int n4 = string.length() % 4;
        n4 = n4 == 0 ? (n4 += 4) : 4 - n4;
        for (int i = 0; i < n4; ++i) {
            string = string + "\u0000";
        }
        System.out.println("The length is " + (n2 += string.length()));
        try {
            Hashtable hashtable = fSPCmdMgr.doPhypCommand(SET_IO_DRAWER_CONFIG_ID, new String[]{new UnsignedInt16(n2).toString(), unsignedInt16.toString(), new UnsignedInt8(s).toString(), new UnsignedInt8((short)string.length()).toString(), ByteUtilities.toHexString(string.getBytes())});
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            n = pIHscCmdMgrException.getStatus();
            HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
            if (n == 25) {
                throw new PIHscServerException("3421", pIHscCmdMgrException);
            }
            if (n == 28) {
                throw new PIHscServerException("3422", pIHscCmdMgrException);
            }
            if (n == 3) {
                throw new PIHscServerException("3423", pIHscCmdMgrException);
            }
            throw new PIHscServerException("3424", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
        }
    }

    public int removePlanarCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8, String string) throws PIHscServerException, PIHscCmdMgrException {
        int n = 20;
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(ANN_ADD_REMOVE_CMD, new String[]{new UnsignedInt32(ANN_TIMEOUT).toString(), new UnsignedInt16(RACK_ADD).toString(), new UnsignedInt16(UNIT_ADD).toString(), new UnsignedInt8(REMOVE_CAGE).toString(), new UnsignedInt8(SPCN_CMD).toString(), new UnsignedInt16(n).toString(), unsignedInt8.toString(), string});
        System.out.println("The ANN REMOVE PLANAR cmd sent down successfully");
        System.out.println("The ANN return value is" + ((UnsignedInt8)hashtable.get("ANN_STATUS")).intValue());
        return ((UnsignedInt8)hashtable.get("ANN_STATUS")).intValue();
    }

    public int addCageCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8, String string) throws PIHscServerException, PIHscCmdMgrException {
        int n = 20;
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(ANN_ADD_REMOVE_CMD, new String[]{new UnsignedInt32(ANN_TIMEOUT).toString(), new UnsignedInt16(RACK_ADD).toString(), new UnsignedInt16(UNIT_ADD).toString(), new UnsignedInt8(ADD_CAGE).toString(), new UnsignedInt8(SPCN_CMD).toString(), new UnsignedInt16(n).toString(), unsignedInt8.toString(), string});
        System.out.println("The ANN ADD CAGE cmd sent down successfully");
        System.out.println("The ANN return value is" + ((UnsignedInt8)hashtable.get("ANN_STATUS")).intValue());
        return ((UnsignedInt8)hashtable.get("ANN_STATUS")).intValue();
    }

    public void clearInactive(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doPhypCommand(CLEAR_INACTIVE, null);
    }

    public UnsignedInt8 clearIoTable(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        int n = 0;
        Hashtable hashtable = null;
        System.out.println("The unit address is " + UNIT_ADD);
        hashtable = fSPCmdMgr.doFSPCommand(CLEAR_IO_TABLE, new String[]{new UnsignedInt32(ANN_TIMEOUT).toString(), new UnsignedInt16(RACK_ADD).toString(), new UnsignedInt16(UNIT_ADD).toString(), new UnsignedInt8(CLEAR_TABLE).toString(), new UnsignedInt8(SPCN_CMD).toString(), new UnsignedInt16(n).toString()});
        System.out.println("The ANN CLEAR IO TABLE cmd sent down successfully");
        System.out.println("The ANN return value is" + ((UnsignedInt8)hashtable.get("ANN_STATUS")).intValue());
        return (UnsignedInt8)hashtable.get("ANN_STATUS");
    }

    static {
        ANN_TIMEOUT = 60000L;
        RACK_ADD = 0;
        UNIT_ADD = 53248;
        REMOVE_CAGE = (short)3;
        SPCN_CMD = (short)67;
        ADD_CAGE = (short)2;
        CLEAR_TABLE = (short)4;
    }
}

